unit Vektor2D;

interface
type
       TVektor2D=class
       protected
         // adatmezk
           fx,fy : real;
       public
        // metdusok
           function  LekerX : real;
           procedure BeallitX(x : real);
           function  LekerY : real;
           procedure BeallitY(y : real);
           function  LekerA : real;
           procedure BeallitA(a : real);
           function  LekerD : real;
           procedure BeallitD(d : real);
           function  VektorToStr : string; virtual;
           function  PVektorToStr : string; virtual;
           procedure Polar(d,a : real);
       published
           constructor Letrehoz(a,b : real);
           constructor LetrehozPolar(d,a :real);
           class function HanyDimenzios : integer; virtual;
        // tulajdonsgok
           property x : real read fx write BeallitX;
           property y : real read fy write BeallitY;
           property a : real read LekerA write BeallitA;
           property d : real read LekerD write BeallitD;
      end;

implementation
uses sysutils;

const FokRad:real=180/PI;

// Inicializl metdus
constructor TVektor2D.Letrehoz(a,b : real);
begin
  fx:=a;
  fy:=b
end;

constructor TVektor2D.LetrehozPolar(d,a :real);
begin
  Polar(d,a);
end;

// Osztlymetdus
class function TVektor2D.HanyDimenzios : integer;
begin
  result:=2;
end;

// A vektor koordintit lekrdez fggvnyek
function  TVektor2D.LekerX : real;
begin
  result:=Self.fx;
end;

function  TVektor2D.LekerY : real;
begin
  result:=Self.fy;
end;

function  TVektor2D.LekerA : real;
begin
  if fx<>0 then
      result:=arctan(fy/fx)*FokRad
  else
      result:=90;
end;

function  TVektor2D.LekerD : real;
begin
  result:=sqrt(sqr(fx)+sqr(fy));
end;

// A vektor koordintit bellt eljrsok
procedure TVektor2D.BeallitX(x:real);
begin
  fx:=x;
end;

procedure TVektor2D.BeallitY(y:real);
begin
  fy:=y;
end;

procedure TVektor2D.BeallitA(a:real);
begin
  Polar(self.d,a);
end;

procedure TVektor2D.BeallitD(d:real);
begin
  Polar(d,self.a);
end;

// A vektor sztringg alaktsa
function TVektor2D.VektorToStr:string;
begin
  result:=format('(%.0f,%.0f)',[x,y]);
end;

function TVektor2D.PVektorToStr:string;
begin
  result:=format('(%.0f<%.0f)',[d,a]);
end;

// A vektor belltsa polr-koordintk segtsgvel
procedure TVektor2D.Polar(d,a:real);
begin
  fx:=d*cos(a/fokrad);
  fy:=d*sin(a/fokrad);
end;

end.
